<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PricingRequest extends Eloquent {

	protected $table = 'pricing_requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function storageDuratipn()
	{
		return $this->hasOne('StorageDuration');
	}

	public function storgeType()
	{
		return $this->hasOne('StorageType');
	}

	public function storageTemp()
	{
		return $this->hasOne('StorageTemprature');
	}

	public function User()
	{
		return $this->belongsTo('User');
	}

}