<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Wishlist extends Model 
{

    protected $table = 'wishlists';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsToMany('User', 'user_wishlist');
    }

    public function product()
    {
        return $this->belongsTo('Product')->whereReviewed(true);
    }

    public function type()
    {
        return $this->belongsTo('ProductVariationType', 'product_variation_type_id');
    }

}