<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code', 32);
			$table->integer('user_id')->unsigned()->index();
			$table->integer('amount')->default('1');
			$table->boolean('active')->default(1);
			$table->timestamp('expires_at')->nullable();
			$table->float('percentage')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}