<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cart extends Model 
{

    protected $table = 'carts';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsToMany('User', 'cart_user');
    }

    public function product()
    {
        return $this->belongsTo('Product')->whereReviewed(true);
    }

    public function type()
    {
        return $this->belongsTo('ProductVariationType', 'product_variation_type_id');
    }

}