<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function owner()
    {
        return $this->belongsTo('User', 'user_id', 'id');
    }

    public function categories()
    {
        return $this->belongsToMany('Category');
    }

    public function sales()
    {
        return $this->morphMany('Sale', 'saleable')->whereActive(true);
    }

}