<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesTable extends Migration {

	public function up()
	{
		Schema::create('sales', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('percentage');
			$table->integer('saleable_id');
			$table->string('saleable_type');
			$table->boolean('active')->default(1);
			$table->integer('user_id')->unsigned();
			$table->timestamp('expires_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sales');
	}
}