<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 32);
			$table->string('email');
			$table->string('password');
			$table->string('location', 191);
			$table->softDeletes();
			$table->timestamps();
			$table->rememberToken('remember_token');
			$table->timestamp('email_verified_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}