<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehouses1Table extends Migration {

	public function up()
	{
		Schema::create('warehouses_1', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('location_id');
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->string('code', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('image', 255);
			$table->tinyInteger('is_main')->default('1');
			$table->enum('type', array('warehouse-sales_branch'));
			$table->tinyInteger('has_security_personal')->default('1');
			$table->tinyInteger('is_rented')->default('1');
			$table->tinyInteger('is_ram_warehouse')->default('1');
			$table->bigInteger('default_employee');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('warehouses_1');
	}
}