<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('warehouses_1', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('warehouses_1')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('warehouse_employees2', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses_1')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouse_employees2', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employee')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('warehouse_sales_branches3', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses_1')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouse_sales_branches3', function(Blueprint $table) {
			$table->foreign('sales_branch_id')->references('id')->on('warehouses_1')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clients2', function(Blueprint $table) {
			$table->foreign('consumer_type_id')->references('id')->on('consumer_types1')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('client_point_of_sells4', function(Blueprint $table) {
			$table->foreign('sales_branch_id')->references('id')->on('warehouses_1')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('client_point_of_sells4', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients2')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('point_of_sell_sessions5', function(Blueprint $table) {
			$table->foreign('client_point_of_sell_id')->references('id')->on('client_point_of_sells4')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('point_of_sell_session_histories6', function(Blueprint $table) {
			$table->foreign('point_of_sell_session_id')->references('id')->on('point_of_sell_sessions5')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->foreign('from_warehouse_id')->references('id')->on('warehouses_1')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->foreign('to_warehouse_id')->references('id')->on('warehouses_1')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->foreign('from_employee_id')->references('id')->on('employee')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->foreign('to_employee_id')->references('id')->on('employee')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('suppliers3', function(Blueprint $table) {
			$table->foreign('consumer_type_id')->references('id')->on('consumer_types1')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('suppliers3', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currenices1')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('warehouses_1', function(Blueprint $table) {
			$table->dropForeign('warehouses_1_parent_id_foreign');
		});
		Schema::table('warehouse_employees2', function(Blueprint $table) {
			$table->dropForeign('warehouse_employees2_warehouse_id_foreign');
		});
		Schema::table('warehouse_employees2', function(Blueprint $table) {
			$table->dropForeign('warehouse_employees2_employee_id_foreign');
		});
		Schema::table('warehouse_sales_branches3', function(Blueprint $table) {
			$table->dropForeign('warehouse_sales_branches3_warehouse_id_foreign');
		});
		Schema::table('warehouse_sales_branches3', function(Blueprint $table) {
			$table->dropForeign('warehouse_sales_branches3_sales_branch_id_foreign');
		});
		Schema::table('clients2', function(Blueprint $table) {
			$table->dropForeign('clients2_consumer_type_id_foreign');
		});
		Schema::table('client_point_of_sells4', function(Blueprint $table) {
			$table->dropForeign('client_point_of_sells4_sales_branch_id_foreign');
		});
		Schema::table('client_point_of_sells4', function(Blueprint $table) {
			$table->dropForeign('client_point_of_sells4_client_id_foreign');
		});
		Schema::table('point_of_sell_sessions5', function(Blueprint $table) {
			$table->dropForeign('point_of_sell_sessions5_client_point_of_sell_id_foreign');
		});
		Schema::table('point_of_sell_session_histories6', function(Blueprint $table) {
			$table->dropForeign('point_of_sell_session_histories6_point_of_sell_session_id_foreign');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->dropForeign('warehouse_transactions7_from_warehouse_id_foreign');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->dropForeign('warehouse_transactions7_to_warehouse_id_foreign');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->dropForeign('warehouse_transactions7_from_employee_id_foreign');
		});
		Schema::table('warehouse_transactions7', function(Blueprint $table) {
			$table->dropForeign('warehouse_transactions7_to_employee_id_foreign');
		});
		Schema::table('suppliers3', function(Blueprint $table) {
			$table->dropForeign('suppliers3_consumer_type_id_foreign');
		});
		Schema::table('suppliers3', function(Blueprint $table) {
			$table->dropForeign('suppliers3_currency_id_foreign');
		});
	}
}