<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentServicesTable extends Migration {

	public function up()
	{
		Schema::create('attachment_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->integer('serviceable_id')->unsigned();
			$table->string('serviceable_type');
			$table->decimal('cost');
			$table->decimal('amount');
		});
	}

	public function down()
	{
		Schema::drop('attachment_services');
	}
}