<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('username')->unique();
			$table->string('email')->unique();
			$table->string('phone')->unique();
			$table->string('password');
			$table->integer('job');
			$table->boolean('active')->default(0);
			$table->integer('clinic_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}