<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BlogPost extends Eloquent {

	protected $table = 'blog_posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'sub_title', 'content');

	public function blog()
	{
		return $this->belongsTo('App\Classes\Blog');
	}

	public function rejection()
	{
		return $this->hasOne('App\Classes\Reject');
	}

}