<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Upgrade extends Eloquent {

	protected $table = 'upgrades';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->hasOne('App\Classes\UpgradeType');
	}

	public function player()
	{
		return $this->belongsTo('App\Classes\Player');
	}

}