<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Blog extends Eloquent {

	protected $table = 'blogs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function blogPost()
	{
		return $this->hasMany('App\Classes\BlogPost');
	}

	public function profile()
	{
		return $this->belongsTo('App\Classes\Profile');
	}

}