<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function profiles()
	{
		return $this->hasMany('App\Classes\Profile');
	}

	public function game()
	{
		return $this->belongsTo('App\Classes\Game');
	}

}