<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Profile extends Eloquent {

	protected $table = 'profiles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nickname', 'naf_number', 'quote');
	protected $visible = array('quote');

	public function blogs()
	{
		return $this->hasMany('App\Classes\Blog');
	}

	public function location()
	{
		return $this->belongsTo('App\Classes\Location');
	}

	public function conversations()
	{
		return $this->hasMany('App\Classes\Conversation');
	}

	public function user()
	{
		return $this->belongsTo('App\Classes\User');
	}

	public function games()
	{
		return $this->hasMany('App\Classes\Game');
	}

}