<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Skill extends Eloquent {

	protected $table = 'skills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function players()
	{
		return $this->belongsToMany('App\Classes\Player');
	}

}