<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Conversation extends Eloquent {

	protected $table = 'conversations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function messages()
	{
		return $this->hasMany('App\Classes\Message');
	}

	public function profiles()
	{
		return $this->belongsToMany('App\Classes\Profile');
	}

}