<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Player extends Eloquent {

	protected $table = 'players';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function teams()
	{
		return $this->belongsToMany('App\Classes\Team');
	}

	public function skills()
	{
		return $this->hasMany('App\Classes\Skill');
	}

	public function type()
	{
		return $this->hasOne('App\Classes\PlayerType');
	}

	public function race()
	{
		return $this->hasOne('App\Classes\Race');
	}

	public function upgrades()
	{
		return $this->hasMany('App\Classes\Upgrade');
	}

}