<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('blog_post_id')->unsigned();
			$table->integer('profile_id')->unsigned();
			$table->timestamp('start_date');
			$table->timestamp('end_date');
			$table->boolean('can_show');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}