<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nickname')->unique();
			$table->string('naf_number')->unique()->nullable();
			$table->string('quote');
			$table->timestamp('birthday');
			$table->timestamp('coach_since')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('location_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}