<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRouteTable extends Migration {

	public function up()
	{
		Schema::create('route', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('departure_place', 255);
			$table->string('arrival_place', 255);
			$table->timestamp('departure_time');
			$table->string('arrival_fulladdress', 255);
			$table->timestamp('arrival_time')->nullable();
			$table->integer('freight_id')->unsigned();
			$table->integer('driver_id')->unsigned();
			$table->string('departure_street', 255)->nullable();
			$table->string('departure_street_no', 255)->nullable();
			$table->string('departure_city', 255)->nullable();
			$table->string('departure_postcode', 255)->nullable();
			$table->string('departure_region', 255)->nullable();
			$table->string('arrival_city', 255)->nullable();
			$table->string('arrival_street', 255)->nullable();
			$table->string('arrival_street_no', 255)->nullable();
			$table->string('arrival_postcode', 255);
			$table->string('arrival_region', 255)->nullable();
			$table->string('max_load', 255)->nullable();
			$table->string('load', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('route');
	}
}