<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentTable extends Migration {

	public function up()
	{
		Schema::create('shipment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('shipmentrequest_id')->unsigned();
			$table->string('tracking_number', 255);
			$table->integer('route_id')->unsigned();
			$table->enum('status', array('processing', 'delivered'));
			$table->timestamp('pickup_time')->nullable();
			$table->timestamp('delivery_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipment');
	}
}