<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('shipment_request', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('driver')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipment_request', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('driver')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipment_request', function(Blueprint $table) {
			$table->foreign('freight_id')->references('id')->on('freight')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipment', function(Blueprint $table) {
			$table->foreign('shipmentrequest_id')->references('id')->on('shipment_request')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipment', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('route')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('route', function(Blueprint $table) {
			$table->foreign('freight_id')->references('id')->on('freight')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('route', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('driver')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fleet', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('driver')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipmenttext', function(Blueprint $table) {
			$table->foreign('shipment_request_id')->references('id')->on('shipment_request')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('shipment_request')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rating', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('driver')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rating', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('freightcategories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('freightcategories')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('shipment_request', function(Blueprint $table) {
			$table->dropForeign('shipment_request_client_id_foreign');
		});
		Schema::table('shipment_request', function(Blueprint $table) {
			$table->dropForeign('shipment_request_driver_id_foreign');
		});
		Schema::table('shipment_request', function(Blueprint $table) {
			$table->dropForeign('shipment_request_freight_id_foreign');
		});
		Schema::table('shipment', function(Blueprint $table) {
			$table->dropForeign('shipment_shipmentrequest_id_foreign');
		});
		Schema::table('shipment', function(Blueprint $table) {
			$table->dropForeign('shipment_route_id_foreign');
		});
		Schema::table('route', function(Blueprint $table) {
			$table->dropForeign('route_freight_id_foreign');
		});
		Schema::table('route', function(Blueprint $table) {
			$table->dropForeign('route_driver_id_foreign');
		});
		Schema::table('fleet', function(Blueprint $table) {
			$table->dropForeign('fleet_seller_id_foreign');
		});
		Schema::table('shipmenttext', function(Blueprint $table) {
			$table->dropForeign('shipmenttext_shipment_request_id_foreign');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->dropForeign('payment_client_id_foreign');
		});
		Schema::table('rating', function(Blueprint $table) {
			$table->dropForeign('rating_driver_id_foreign');
		});
		Schema::table('rating', function(Blueprint $table) {
			$table->dropForeign('rating_client_id_foreign');
		});
		Schema::table('freightcategories', function(Blueprint $table) {
			$table->dropForeign('freightcategories_parent_id_foreign');
		});
	}
}