<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCharactersTable extends Migration {

	public function up()
	{
		Schema::create('characters', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('user_id')->unsigned()->index();
			$table->tinyInteger('chronicle_id');
			$table->string('name', 20);
			$table->string('clan', 20);
			$table->tinyInteger('generation');
			$table->smallInteger('experience_points')->default('0');
			$table->string('sire', 20);
			$table->tinyInteger('true_age');
			$table->tinyInteger('apparent_age');
			$table->integer('embrace_year');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('characters');
	}
}