<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function websites()
	{
		return $this->hasMany('App\Credential');
	}

	public function contacts()
	{
		return $this->morphMany('App\Contact', 'contactable');
	}

}