<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Credentialfield extends Eloquent {

	protected $table = 'credentialfields';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('field_label');

	public function credentialtype()
	{
		return $this->belongsTo('App\Credentialtype');
	}

	public function credentials()
	{
		return $this->hasManyThrough('App\Credential', 'App\Credentialtype');
	}

}