<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWebsitesTable extends Migration {

	public function up()
	{
		Schema::create('websites', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('active');
			$table->string('ip');
			$table->string('phpform');
			$table->boolean('dns_control');
			$table->string('cms');
			$table->string('cms_version');
			$table->boolean('responsive');
			$table->enum('renewal_month', array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'));
			$table->date('hosting');
			$table->boolean('revel_care');
			$table->date('launch');
			$table->date('start');
			$table->string('imagequestdomains');
			$table->string('managed_analytics');
			$table->integer('company_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('websites');
	}
}