<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceCategoryTable extends Migration {

	public function up()
	{
		Schema::create('service_category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->boolean('show')->default(1);
			$table->boolean('is_new')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('service_category');
	}
}