<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceTable extends Migration {

	public function up()
	{
		Schema::create('service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('description_en')->nullable();
			$table->string('description_ar')->nullable();
			$table->integer('duration')->nullable();
			$table->double('price')->nullable();
			$table->integer('rate')->nullable();
			$table->string('details_en')->nullable();
			$table->string('details_ar')->nullable();
			$table->boolean('show')->nullable()->default(1);
			$table->integer('category_id')->nullable();
			$table->boolean('is_new')->nullable()->default(0);
			$table->string('odoo_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('service');
	}
}