<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DiscountBranch extends Eloquent {

	protected $table = 'discount_branch';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('discount_id', 'branch_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function discount()
	{
		return $this->belongsTo('Discount', 'discount_id');
	}

}