<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OfferGetproduct extends Eloquent {

	protected $table = 'offer_getproduct';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'offer_id');
	protected $visible = array('product_id');

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

	public function offer()
	{
		return $this->belongsTo('Offer', 'offer_id');
	}

}