<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OfferGetservice extends Eloquent {

	protected $table = 'offer_getservice';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('service_id', 'offer_id');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function offer()
	{
		return $this->belongsTo('Offer', 'offer_id');
	}

}