<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OfferProduct extends Eloquent {

	protected $table = 'offer_product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('offer_id', 'product_id');

	public function offer()
	{
		return $this->belongsTo('Offer', 'offer_id');
	}

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

}