<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rating extends Eloquent {

	protected $table = 'rating';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'question1', 'question2', 'question3', 'question4', 'question5', 'total_rate', 'show', 'review', 'branch_id');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function rating_service()
	{
		return $this->hasMany('RatingService', 'rating_id');
	}

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

}