<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RatingService extends Eloquent {

	protected $table = 'rating_service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'rating_id', 'service_id', 'worker_id', 'rate', 'show', 'review', 'branch_id');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function worker()
	{
		return $this->belongsTo('Worker', 'worker_id');
	}

	public function rating()
	{
		return $this->belongsTo('Rating', 'rating_id');
	}

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

}