<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Schedule extends Eloquent {

	protected $table = 'schedule';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('days', 'from_hour', 'to_hour', 'is_day_off', 'branch_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

}