<?php

namespace API;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Offer extends Model 
{

    protected $table = 'offer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'from_date', 'to_date', 'description_en', 'description_ar', 'show_product', 'uses', 'discount_type', 'amount', 'to_buy', 'to_get', 'n_services');

    public function buy_services()
    {
        return $this->belongsToMany('Service', 'offer_service', 'offer_id', 'service_id');
    }

    public function buy_products()
    {
        return $this->belongsToMany('Product', 'offer_product', 'offer_id', 'product_id');
    }

    public function branches()
    {
        return $this->belongsToMany('Branch', 'offer_branch', 'offer_id', 'branch_id');
    }

    public function get_services()
    {
        return $this->belongsToMany('Service', 'offer_getservice', 'offer_id', 'service_id');
    }

    public function get_products()
    {
        return $this->belongsToMany('Product', 'offer_getproduct', 'offer_id', 'product_id');
    }

}