<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DiscountBranch extends Model 
{

    protected $table = 'discount_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('discount_id', 'branch_id');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function discount()
    {
        return $this->belongsTo('Discount', 'discount_id');
    }

}