<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OfferGetservice extends Model 
{

    protected $table = 'offer_getservice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('service_id', 'offer_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function offer()
    {
        return $this->belongsTo('Offer', 'offer_id');
    }

}