<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserBranches extends Model 
{

    protected $table = 'user_branches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'branch_id');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}