<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkingDay extends Model 
{

    protected $table = 'working_day';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('worker_id', 'shift_id', 'day', 'is_day_off');

    public function worker()
    {
        return $this->belongsTo('Worker', 'worker_id');
    }

    public function shift()
    {
        return $this->belongsTo('Shift', 'shift_id');
    }

}