<?php

namespace Freelance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Professional extends Model 
{

    protected $table = 'professionals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function projectsApplied()
    {
        return $this->belongsToMany('Project');
    }

    public function projectsWon()
    {
        return $this->belongsToMany('Project');
    }

    public function projectsFinished()
    {
        return $this->belongsToMany('Project');
    }

}