<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name');
			$table->string('last_name')->nullable();
			$table->string('password');
			$table->boolean('active')->default(0);
			$table->integer('wallet')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}