<?php

namespace Freelance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Professional extends Eloquent {

	protected $table = 'professionals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function projectsApplied()
	{
		return $this->belongsToMany('Project');
	}

	public function projectsWon()
	{
		return $this->belongsToMany('Project');
	}

	public function projectsFinished()
	{
		return $this->belongsToMany('Project');
	}

}