<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pegawai extends Eloquent {

	protected $table = 'pegawai';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'nip', 'username', 'personnel_area', 'personnel_subarea', 'personnel_area_name', 'personnel_subarea_name', 'position');

	public function mapping()
	{
		return $this->hasMany('App\Mapping', 'personnnel_subarea_name', 'unit');
	}

}