<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_serial_number');
			$table->integer('store_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->tinyInteger('order_status')->index();
			$table->integer('payment_status')->index();
			$table->tinyInteger('order_type');
			$table->string('total_amount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}