<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAboutMediaTable extends Migration {

	public function up()
	{
		Schema::create('about_media', function(Blueprint $table) {
			$table->increments('id');
			$table->text('thumbnail');
			$table->text('thumbnail_alt');
			$table->enum('media_type', array('video', 'image'));
			$table->text('media_desktop_path');
			$table->text('media_mobile_path');
			$table->text('media_alt');
			$table->tinyInteger('sort_order');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('about_media');
	}
}