<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeCmsTable extends Migration {

	public function up()
	{
		Schema::create('home_cms', function(Blueprint $table) {
			$table->increments('id');
			$table->string('milestone_description');
			$table->string('make_ride_title');
			$table->string('make_ride_highlight_text');
			$table->text('make_ride_description');
			$table->enum('make_ride_media_type', array('video', 'image'));
			$table->text('make_ride_media_desktop_path');
			$table->text('make_ride_media_mobile_path');
			$table->string('make_ride_media_alt');
			$table->string('explore_title');
			$table->text('explore_description');
			$table->string('app_feature_title');
			$table->text('app_feature_description');
			$table->string('app_feature_sub_title');
			$table->enum('app_feature_media_type', array('image', 'video'));
			$table->text('app_feature_media_desktop_path');
			$table->text('app_feature_media_mobile_path');
			$table->text('app_feature_media_alt');
			$table->string('investment_title');
			$table->enum('investment_media_type', array('video', 'image'));
			$table->text('investment_media_desktop_path');
			$table->text('investment_media_mobile_path');
			$table->text('investment_media_alt');
			$table->string('partners_title');
			$table->string('news_title');
			$table->string('blog_title');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('home_cms');
	}
}