<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHeaderAndFooterTable extends Migration {

	public function up()
	{
		Schema::create('header_and_footer', function(Blueprint $table) {
			$table->increments('id');
			$table->text('header_logo');
			$table->string('header_logo_alt');
			$table->string('header_btn_text');
			$table->text('header_btn_link');
			$table->string('subscription_title');
			$table->string('subscription_btn_text');
			$table->text('footer_logo');
			$table->string('footer_logo_alt');
			$table->string('address_one_title');
			$table->text('address_one_description');
			$table->string('address_one_phone');
			$table->string('address_two_title');
			$table->text('address_two_description');
			$table->string('address_two_phone');
			$table->text('apple_store_media_path');
			$table->text('apple_store_media_alt');
			$table->text('play_store_media_path');
			$table->text('play_store_media_alt');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('header_and_footer');
	}
}